### 基于一个函数建立两个线程对象并激活它们
### 本程序说明，启动线程的线程未必是创建线程对象的线程
### 这里主线程创建 th1，而另一子线程 th2 启动 th1
### 在 cmd 中运行说明，
### 如果未结束的只有守护线程，解释器就会强制结束这些线程

from threading import Thread

def myfunc(s, num, other=None):
    if other is not None:
        other.start()
    n = 0
    for i in range(num):
        n += i
    print(str(n) + ", " + s)

th1 = Thread(target=myfunc, args=("Th1.", 20000000, None),
             daemon=True)
th2 = Thread(target=myfunc, args=("Th2.", 10000000, th1))
th2.start() # 激活线程对象，th2 运行中激活 th1
th2.join()
print("Last statement of the main.")
