## 一个构造输入项组的窗口定义

import tkinter as tk
import tkinter.messagebox as mb 

class InputWin(tk.Frame):
    """可用于作为独立的顶层窗口或者作为其他窗口中的部件的数据输入窗口。
创建对象时（初始化方法）的参数说明：
    parent为None表示作为默认窗口的部件，用Toplevel()创建独立的顶层窗口；
    title作为窗口标题；
    button_label指定输入按钮上的文字；
    entries是一个字符串的表，字符串为窗口中各输入项的标签；
    callback指定接收输入的回调函数。
"""
    def __init__(self, title="数据录入", button_label="输入",
                 entries=tuple("None"), callback=lambda x:None):
        """Define a framed window.""" # 文档串
        tk.Frame.__init__(self, tk.Toplevel()) # 初始化Frame实例

        self.master.title(title) # 设置窗口标题
        self.grid() # 安置本Frame

        self._callback = callback
        
        frm = tk.Frame(self)
        frm.grid()
        self._varlist = [] # 实际接收输入的变量表

        # 设置窗口上部的输入框及其标签
        i = 0
        for title in entries: # 通过迭代建立各输入框及其标签
            v = self._build(frm, i, title)
            self._varlist.append(v)
            i += 1

        # 设置窗口下部的按钮
        frm = tk.Frame(self, relief=tk.SUNKEN)
        frm.grid(sticky=tk.EW)
        but1 = tk.Button(frm, text=button_label, width=8,
                         command=self._input_data)
        but1.grid(column=0, row=0, padx=16, pady=1)
        but2 = tk.Button(frm, text="结束", width=8,
                         command=self.master.destroy)
        but2.grid(column=1, row=0, padx=16, pady=1)

    def _build(self, frm, i, lname): # 建立输入项的函数
        label = tk.Label(frm, text=lname, anchor=tk.W)
        label.grid(row=i, column=0, sticky=tk.E+tk.W)
        v = tk.StringVar()
        entry = tk.Entry(frm, textvariable=v, justify=tk.RIGHT)
        entry.grid(row=i, column=1)
        return v

    def _input_data(self):
        message = self._callback([v.get() for v in self._varlist])
        if not message: # 输入被正确接收时清空输入框
            for v in self._varlist: v.set("")
        else:
            mb.showerror("输入错误", message)

if __name__ == "__main__":
#    InputWin().mainloop()
    InputWin(entries=("姓名:", "年龄:", "出生地:"),
             callback=print).mainloop()

##    def output(*args, **kwargs):
##        print(*args, **kwargs)
##        return "检查错误信息的示例"
##    InputWin(entries=("姓名:", "年龄:", "出生地:"),
##             callback=output).mainloop()
