#### 从求立方根函数抽象出的逼近计算框架

def appr_method(x, improve, accept):
    if x == 0.0:
        return 0.0
    x1 = x
    while True:
        x2 = improve(x, x1)
        if accept(x1, x2):
            return x2
        x1 = x2
    return x2

## 基于逼近框架的立方根函数

def cbrt(x):
    def cb_improve(x, x1):
        return(2.0 * x1 + x / x1 / x1) / 3
        
    def accept(x1, x2):
        return abs((x2 - x1)/x1) < 1E-6
    
    return appr_method(x, cb_improve, accept)

## 基于逼近框架的平方根函数

def sqrt(x):
    def sq_improve(x, x1):
        return (x1 + x/x1)/2

    def accept(x1, x2):
        return abs((x2 - x1)/x1) < 1E-8
    
    return appr_method(x, sq_improve, accept)

