# 本模块通过继承内置list类型，定义一个可循环移位的表类型

class RotatableList(list):
    def rot_left(self, num):
        if not self or len(self) == 1:
            return
        for i in range(num):
            x = self.pop(0)
            self.append(x)

    def rot_right(self, num):
        if not self or len(self) == 1:
            return
        for i in range(num):
            x = self.pop()
            self.insert(0, x)

if __name__ == "__main__":
    ls = RotatableList()
    for i in range(10):
        ls.append(i)
    print(ls)

    ls.rot_left(3)
    print(ls)
    ls.rot_right(7)
    print(ls)

    ls1 = RotatableList((1, 2, 3, 4, 5, 6))
    print(ls1)

    ls2 = RotatableList("Good lucky!")
    print(ls2)
    ls2.rot_left(5)
    print(ls2)

