#### 使用子迭代器的yield语句的程序实例

def read_floats(fname):
    infile = open(fname)
    while True:
        line = infile.readline()
        if not line:  # end of file
            infile.close()
            return
        yield from map(float, line.split())

def read_files(fname_list):
    for fname in fname_list:
        yield from read_floats(fname)

def test_gen(value=None):
     print("Starts when 'next()' is called for the first time.")
     try:
         while True:
             try:
                 value = (yield value)
                 print("Receive value:", value)
             except Exception as e:
                 value = e
     finally:
         print("Remember to clean up when 'close()' is called.") 

gen = test_gen(3)

##if __name__ == "__main__":
##    floats = read_floats("data.dat")
##    fsum = 0.0
##    num = 0
##    for x in floats:
##        fsum += x
##        num += 1
##    print(num, fsum, fsum/num)
