###### 输入和计算圆盘面积

import tkinter as tk
import math

class DiskAreaCalculate(tk.Frame):
    def __init__(self):
        tk.Frame.__init__(self)
        self.master.title("Disk Area Calculator")
        self.grid()
        
        # Label and field for inputing radius
        self._radiusLabel = tk.Label(self, text="Radius:")
        self._radiusLabel.grid(row=0, column=0)
        self._radiusVar = tk.DoubleVar()
        self._radiusEntry = tk.Entry(self, justify=tk.RIGHT,
                                textvariable=self._radiusVar)
        self._radiusEntry.grid(row=0, column=1, sticky=tk.E)

        # Label and field for showing the area
        self._areaLabel = tk.Label(self, text="Area:")
        self._areaLabel.grid(row=1, column=0, sticky=tk.E)
        self._areaVar = tk.DoubleVar()
        self._areaEntry = tk.Label(self, 
                                textvariable=self._areaVar)
        self._areaEntry.grid(row=1, column=1, sticky=tk.E)
        
        # The command button
        self._button = tk.Button(self, text="Compute",
                                 command=self._area)
        self._button.grid(row=2, column=0, columnspan=2)

    def _area(self):
        """Event handler for the button."""
        try:
            radius = self._radiusVar.get()
            area = radius**2 * math.pi
            self._areaVar.set(area)
        except tk.TclError as ex:
            tk.messagebox.showerror(title="Disk Area: Error",
                            parent=self, message=str(ex))

DiskAreaCalculate().mainloop()
