def read_floats(fname):
    infile = open(fname)
    while True:
        line = infile.readline()
        if not line:  # end of file
            infile.close()
            return
        for s in line.split():
            yield float(s)

if __name__ == "__main__":
    floats = read_floats("data.dat")
    fsum = 0.0
    num = 0
    for x in floats:
        fsum += x
        num += 1
    print(num, fsum, fsum/num)
