#### 另一种实现，其中使用了局部函数和局部变量
#### 返回局部定义的函数对象（实际上带着局部环境）

def read_floats(fname):
    nlist = []
    infile = open(fname)
    crt = 0

    def next_float():
        nonlocal nlist, crt
        if crt == len(nlist): # 一行已经用完
            line = infile.readline()
            if not line: # line是空串，整个文件已经处理完
                infile.close()
                return None
            nlist = line.split()
            crt = 0
        crt += 1
        return float(nlist[crt - 1])

    return next_float # 返回局部定义的函数对象
# end of open_float

if __name__ == "__main__":
    nextf1 = read_floats("data.dat")

    for i in range(10):
        print(nextf1())
    print("-------------")

    nextf2 = read_floats("datafile.dat")

    for j in range(10):
        print(nextf2())
    print("-------------")

    for i in range(10):
        print(nextf1())
