#### 数值微分函数和应用实例
####
epsilon = 0.001
def diff(f):
    return lambda x: (f(x + epsilon) - f(x))/epsilon

from math import sin, pi
print("diff(sin)(0.0) =", diff(sin)(0.0))
print("diff(sin)(pi/2) =", diff(sin)(pi/2))
print("diff(sin)(pi) =", diff(sin)(pi))

def cube(x):
    return x*x*x

print("diff(cube)(1.0) =", diff(cube)(1.0))
print("diff(cube)(10.0) =", diff(cube)(10.0))
