##  包含两个按钮的窗口，表现状态切换等特征

import tkinter as tk

class TwoButtonWin(tk.Frame):
    def __init__(self):
        """Sets up the window and widgets."""
        tk.Frame.__init__(self)
        self.master.title("Button Win")
        self.grid()
        self._label = tk.Label(self, text="Begin", width=20)
        self._label.grid()
        self._button1 = tk.Button(self,
                                 text="Coming",
                                 command=self._switch)
        self._button1.grid()
        self._button2 = tk.Button(self,
                                 text="Leaving",
                                 command=self._switch,
                                 state=tk.DISABLED)
        self._button2.grid()
        
    def _switch(self):
        """Event handler for the button."""
        if self._label["text"] == "Hello!":
            self._label["text"] = "Goodbye!"
            self._button1["state"] = tk.NORMAL
            self._button2["state"] = tk.DISABLED
        else:
            self._label["text"] = "Hello!"
            self._button2["state"] = tk.NORMAL
            self._button1["state"] = tk.DISABLED

TwoButtonWin().mainloop()

