/* =========== Exam.9-9, p245 ========== */

#include <stdio.h>
#include <stdlib.h>

typedef struct {
    double re, im;
} Complex;

Complex addComplex(Complex x, Complex y);
Complex subComplex(Complex x, Complex y);
Complex tmsComplex(Complex x, Complex y);
Complex divComplex(Complex x, Complex y);
Complex mkComplex(double re, double im);
Complex d2Complex(double d);
Complex n2Complex(int n);
void prtComplex(FILE *fp, Complex x);
int readComplex(FILE *fp, Complex *xp);


Complex mkComplex(double r, double i) {
    Complex c;
    c.re = r;
    c.im = i;
    return c;
}

Complex d2Complex(double d)  {
    Complex c;
    c.re = d;
    c.im = 0;
    return c;
}

Complex n2Complex(int n)  {
    Complex c;
    c.re = n;
    c.im = 0;
    return c;
}

Complex addComplex(Complex x, Complex y) {
    Complex c;
    c.re = x.re + y.re;
    c.im = x.im + y.im;
    return c;
}

Complex divComplex(Complex x, Complex y) {
    Complex c;
    double den = y.re * y.re + y.im * y.im;

    if (den == 0.0) {
        fprintf(stderr, "Complex error: divid 0.\n");
        c.re = 1; c.im = 0;
    }
    else {
        c.re = (x.re * y.re + x.im * y.im) / den;
        c.im = (x.im * y.re - x.re * y.im) / den;
    }
    return c;
}

void prtComplex(FILE *fp, Complex x) {
    fprintf(fp, "(%f, %f)", x.re, x.im);
}



