#include <stdio.h>

typedef double (* MFP)(double);

void trans_int(int *begin, int *end, int (*fp)(int)) {
    for ( ; begin < end; ++begin)
        *begin = fp(*begin);
}

void trans_double(double *begin, double *end, MFP fp) {
    for ( ; begin < end; ++begin)
        *begin = fp(*begin);
}

int * mismatch_int(int *begin, int *end, int *second, 
                   int (*fp)(int, int)) {
    for ( ; begin < end; ++begin, ++second)
        if (fp(*begin, *second) == 0) break;
    return begin;
}


