/* ========== Exam.7-14, p203 ======== */

#include <stdio.h>

typedef double (* MFP)(double);

double cross(MFP fp, double x1, double x2) {
    double y1 = fp(x1), y2 = fp(x2);

    return (x1 * y2 - x2 * y1) / (y2 - y1);
}

double root(MFP fp, double x1, double x2) {
    double x, y, y1 = fp(x1);

    do {
        x = cross(fp, x1, x2);
        y = fp(x);
        if (y * y1 > 0.0) {
            y1 = y;
            x1 = x;
        }
        else
            x2 = x;
    } while (y >= 1E-6 || y <= -1E-6);

    return x;
}

