/* ========== Exam.7-12, p198 ======== */

#include <stdio.h>
#include <math.h>

/* ֱͼ߶ */
enum { NUM = 200, HISTOHIGH = 60 };

double scores[NUM];

double* readscores(int* np); /*ݣضַ̬ͨnpͻ*/
void statistics(int num, double tb[]); /*ͳtbnum*/
void histogram(int num, double tb[], int high); /*Ϊhighֱͼ*/

int main() {
    int n;
    double *scores;
    if ((scores = readscores(&n)) == NULL)
        return 1;
    statistics(n, scores);
    histogram(n, scores, HISTOHIGH);
    return 0;
}

enum { INITNUM = 20 };

double* readscores(int* np) {
    unsigned curnum, n;
    double *p, *q, x;

    if ((p = (double*)malloc(INITNUM*sizeof(double))) == NULL) {
        printf("No memory. Stop\n");
        *np = 0;
        return NULL;
    }

    for(curnum = INITNUM, n = 0; scanf("%lf", &x) == 1; ++n) {
        if (n == curnum) {
            q = (double*)realloc(p, 2*curnum*sizeof(double));
            if (q == NULL) {
                printf("No enough memory. Process %d scores.\n", n);
                break;
            }
            p = q; curnum *= 2;
        }
        p[n] = x;
    }
    *np = n;

    return p;
}

void statistics(int n, double tb[]) {
    int i;
    double s, sum, avr;

    if (n <= 1) {
        printf("Data too few."
               " Can't produce mean and standard-deviation.\n");
        return;
    }

    for (sum = 0.0, i = 0; i < n; ++i) sum += tb[i];
    avr = sum/n;
    for (sum = 0.0, i = 0; i < n; ++i)
        sum += (tb[i] - avr)*(tb[i] - avr);
    s = sqrt(sum/(n-1));

    printf("Total students: %d\n", n);
    printf("Average score: %f\n", avr);
    printf("Standard deviation: %f\n\n", s);
}

void prtHH(int n) {
    int i;
    for (i = 0; i < n; ++i) putchar('H');
}

enum { SEGLEN = 5,
    HISTONUM = (100/SEGLEN)+1 };

void histogram(int n, double tb[], int high) {
    int i, mx;
    int segs[HISTONUM];

    if (n == 0) return;

    for (i = 0; i < HISTONUM; ++i) segs[i] = 0; /* ʼ */
    for (i = 0; i < n; ++i) /* ͳƸֶ */
        segs[(int)tb[i]/SEGLEN]++;

    for (mx = 1, i = 0; i < HISTONUM; ++i) /* Ϊ淶ҳ */
        if (segs[i] > mx) mx = segs[i];

    for (i = 0; i < HISTONUM; ++i) { /*  */
        printf("<%3d: %4d|", (i+1)*SEGLEN, segs[i]);
        prtHH(segs[i]*high/mx);
        putchar('\n');
    }
    putchar('\n');
}


