#### 类装饰器，用于追踪对象的属性访问（方法访问）

def traceattrs(cls):
    class Wrapper:
        def __init__(self, *args, **kwargs):
            self.wrapped = cls(*args, **kwargs)

        def __getattr__(self, attr):
            print("Accessing {}.{}.".format(cls.__name__, attr))
            return getattr(self.wrapped, attr)

    return Wrapper

@traceattrs
class Point:
    def __init__(self, x, y):
        self._x = x
        self._y = y

    def getx(self):
        print(self._x)
        return self._x

    def gety(self):
        print(self._y)
        return self._y

    def area(self):
        print(0)
        return 0

    def move(self, delta_x, delta_y):
        self._x += delta_x
        self._y += delta_y
        print("moves to {}".format((self._x, self._y)))

if __name__ == "__main__":
    p = Point(3, 5)
    x = p.getx()
    y = p.gety()
    p.move(3, 7)


