#### 计时修饰器函数

import time

##def timing(fun):
##    accum = 0.0
##    def timer(*args, **kwargs):
##        nonlocal accum
##        print(fun.__name__ + " starts...")
##        start = time.clock()
##        x = fun(*args, **kwargs)
##        duration = time.clock() - start
##        accum += duration
##        print("{} ends: {:12.6f}, {:12.6f}".format(fun.__name__,
##                                                   duration, accum))
##        return x
##
##    return timer


def timing(fun):
    def timer(*args, **kwargs):
        print(fun.__name__ + " starts...")
        start = time.clock()
        x = fun(*args, **kwargs)
        duration = time.clock() - start
        print("{} ends: {:12.6f}".format(fun.__name__, duration))
        return x

    return timer

if __name__ == "__main__":
    @timing
    def func(a, b):
        sum = 0
        for i in range(a, b):
            sum += i
        return sum

    print(func(10000, 20000))
    print(func(100000, 200000))
    print(func(1000000, 2000000))


