## 体现 __setattr__ 和 __getattr__ 功能的代码

print("Test __getattr__ and __setattr__.")

class Important:
    def __init__(self):
        self._time = None
        
    def __setattr__(self, name, value):
        if name == "time":
            if (value is None or
                isinstance(value, tuple) and len(value) == 2 and
                isinstance(value[0], int) and 0 <= value[0] < 24 and
                isinstance(value[1], int) and 0 <= value[1] < 60):

                super().__setattr__("_time", value)
            else:
                raise ValueError
        else:
            super().__setattr__(name, value)

    def __getattr__(self, name):
        if name == "time":
            return self._time
    
x = Important()
x.time = (12, 40)
print(x.time)
#x.time = 3 
x.a = 5

## __getattribute__ 并不劫持对特殊方法名的访问
## 下面是一段检验代码，可以看到它劫持对f和n的访问，并不劫持__add__访问
print("Test __getattribute__.")

class Test:
    def __init__(self, n):
        self.n = n
        
    def __getattribute__(self, name):
        print("__getattribute__ is called")
        print(name)
        print(super().__getattribute__(name))
        return super().__getattribute__(name)

    def f(self): return 1
    def __add__(self, m): self.n += m

x = Test(10)
x.f()
x + 12

              
