# 展示元类技术的示例
# 这里定义一个简单元类，基于它定义的类都具有实例计数功能


class Counter(type):
    def __init__(cls, clsname, bases, attrdict, **kwds):
        init = cls.__init__
        
        def tmp(self, *args, **kwargs): # 定义新版本的初始化函数
            init(self, *args, **kwargs)
            cls.__objnum += 1

        cls.__objnum = 0
        cls.__init__ = tmp # 设置新版本的初始化函数
        cls.objnum = classmethod(lambda cls: cls.__objnum)
        
        
class Shape(metaclass=FunCounter):
    def area(self):
        raise NotImplementedError

    def move(self, delta_x, delta_y):
        raise NotImplementedError

    def name(self): return "Shape"

    def show(self):
        print("I am a", self.name() +".",
              "My area is", self.area()) 

class Point(Shape):
    def __init__(self, x, y):
        Shape.__init__(self)
        self._x = x
        self._y = y

    def getx(self):
        return self._x

    def gety(self):
        return self._y

    def area(self):
        return 0

    def move(self, delta_x, delta_y):
        self._x += delta_x
        self._y += delta_y

    def name(self): return "Point"

class Rectangle(Shape):
    def __init__(self, point, length, width):
        Shape.__init__(self)
        self._point = point
        self._length = length
        self._width = width

    def getx(self):
        return self._point.getx()
    
    def gety(self):
        return self._point.gety()

    def area(self):
        return self._length * self._width

    def move(self, delta_x, delta_y):
        self._point.move(delta_x, delta_y)

    def name(self): return "Rectangle"


def area(slist):
    s = 0
    for x in slist:
        if isinstance(x, Shape):
            s += x.area()
    return s

if __name__ == "__main__":
    x = Point(2, 3)
    y = Rectangle(x, 3, 5)
    z = Rectangle(x, 6, 8)

    x.show()
    y.show()
    z.show()

    print("Total Area:", area([x, y, z]))

    print(Shape.objnum())

