## local_dir.py
## Define a context manager

import os

def localdir(file):
    ldir = LocalDir()
    ldir.save(file)
    return ldir

class LocalDir:
    def save(self, file):
        self.save = os.getcwd()
        chdir(os.path.dirname(file))
    
    def __enter__(self, file):
        return self
 
    def __exit__(self, type, value, trace):
        chdir(self.save)



