## local_dir.py: A context manager for
## turning to local dir and back

import os

##def localdir(file):
##    return LocalDir(file)
##
class LocalDir:
    def __init__(self, file):
        self.save = os.getcwd()
        os.chdir(os.path.dirname(file))
    
    def __enter__(self):
        return self
 
    def __exit__(self, type, value, trace):
        os.chdir(self.save)



