## 实现 property 基本功能的描述器

class Property:
    def __init__(self, getter=None, setter=None, deleter=None, doc=None):
        self._getter = getter
        self._setter = setter
        self._deleter = deleter
        self.__doc__ = doc

    def __get__(self, instance, owner):
        if instance is None:
            return self
        if self._getter is None:
            raise AttributeError("Attribute has no getter.")
        return self._getter(instance)
    
    def __set__(self, instance, value):
        if self._setter is None:
            raise AttributeError("Attribute has no setter.")
        self._setter(instance, value)

    def __delete__(self, instance):
        if self._deleter is None:
            raise AttributeError("Attribute has no deleter.")
        self._deleter(instance)

class C:
    def __init__(self, value):
        self._value = value

    def getter(self):
        print("value's getter is called.")
        return self._value
    
    def setter(self, value):
        print("value's setter is called.")
        self._value = value

    value = Property(getter, setter)
    
x = C(10)
print(x.value)
x.value = 20
print(x.value)
