## 检查时间属性的描述符类及其使用

class Time:
    def __get__(self, instance, owner):
        print("__get__ is called")
        return instance._time
    
    def __set__(self, instance, value):
        print("__set__ is called")
        if (value is None or
            isinstance(value, tuple) and len(value) == 2 and
            isinstance(value[0], int) and 0 <= value[0] < 24 and
            isinstance(value[1], int) and 0 <= value[1] < 60):

            instance._time = value
        else:
            raise ValueError
            
    def __delete__(self, instance):
        print("__delete__ is called")
        if instance._time is None:
            raise ValueError
        instance._time = None

class Important:
    def __init__(self):
        self._time = None

    time = Time()
    # ... ...
    
x = Important()
print(x.time)
x.time = (10, 38)

