# 面向对象编程技术：委托

class Client:
    def __init__(self, obj):
        self.delegatee = obj

    def action1(self, *args):
        print("action1 in Client.") # 根据具体需要实现
    def action2(self, *args):
        print("action2 in Client.") # 根据具体需要实现

    def __getattr__(self, attr):
        return getattr(self.delegatee, attr)

class Worker:
    def __init__(self):
        print("A worker is created.")

    def op1(self):
        print("op1 in Worker.")

    def op2(self):
        print("op2 in Worker.")

class Client1:
    def __init__(self, obj1, obj2):
        self.delegatee1 = obj1
        self.delegatee2 = obj2

    def action1(self, *args):
        print("action1 in Client.") # 根据需要实现
    def action2(self, *args):
        print("action2 in Client.") # 根据需要实现

    def __getattr__(self, attr):
        try: 
            return getattr(self.delegatee1, attr)
        except AttributeError:
            return getattr(self.delegatee2, attr)
           

class Worker1:
    def __init__(self):
        print("A worker1 is created.")

    def op3(self):
        print("op3 in Worker1.")

    def op4(self):
        print("op4 in Worker1.")



if __name__ == "__main__":
    w = Worker()

    c = Client(w)
    c.action1()
    c.op1()
    
    w1 = Worker1()

    c1 = Client1(w, w1)
    c1.action1()
    c1.op1()
    c1.op3()

