#### 修饰器类：实现与 deco_class.py 中decoc同样功能，
#### 通过使用 descriptor 技术，可用于装饰函数或类中方法

class decoc:
    class _Wrapper:
        def __init__(self, descriptor, instance):
            self._desc = descriptor
            self._instance = instance

        def __call__(self, *args, **kwargs):
            return self._desc(self._instance, *args, **kwargs)     

    def __init__(self, fun):
        self._fun = fun

    def __call__(self, *args, **kwargs):
        print(self._fun.__name__ + " starts.")
        x = self._fun(*args, **kwargs)
        print(self._fun.__name__ + " ends.")
        return x

    def __get__(self, instance, onwer):
        return decoc._Wrapper(self, instance)
    

class C: # 这个装饰器也能用于方法
    def __init__(self, v):
        self.v = v

    @decoc
    def add(self, n):
        self.v += n

    @decoc
    def value(self):
        return self.v

@decoc
def func1(a, b):
    print(a + b)
    return a + b

if __name__ == "__main__":
    c = C(10)
    c.add(3)
    print(c.value())

    print("func1:", func1(1, 4))


