#### 装饰器类

def func1(a, b):
    print(a + b)
    return a + b

def func2(a, b, c):
    print(a + b * c)
    return a + b * c

class decoc:
    def __init__(self, fun):
        self.fun = fun

    def __call__(self, *args, **kwargs):
        print(self.fun.__name__ + " starts.")
        x = self.fun(*args, **kwargs)
        print(self.fun.__name__ + " ends.")
        return x

class C: # 这个装饰器类不能用于装饰类方法
    def __init__(self, v):
        self.v = v

    @decoc
    def add(self, n):
        self.v += n

    @decoc
    def value(self):
        return self.v

if __name__ == "__main__":
    func1 = decoc(func1)
    func2 = decoc(func2)
    print("func1:", func1(1, 4))
    print("func2:", func2(2, 3, 4))



