# 文件customers.py
# 本模块定义一个客户类
# 这个模块还作为客户管理器
# 在客户对象中记录了客户消费的积累值

class _Customer:
    def __init__(self, name):
        self._name = name
        self._total = 0.0

    def pay(self, price):
        self._total += price
        return price

    def total(self):
        return self._total

_customers = {}

def new_customer(name):
    if not isinstance(name, str):
        raise TypeError("Create Record Error: ", name)
    _customers[name] = _Customer(name)

def pay_price(name, price):
    if (not isinstance(name, str) or
        not isinstance(price, float)):
        raise TypeError("Purshese Error: ", name, price)
    if name not in _customers: # 无此客户时自动添加
        _customers[name] = _Customer(name)
    return _customers[name].pay(price)

def check_total(name):
    if name not in _customers:
        raise KeyError("No such customer: ", name)
    return _customers[name].total()


if __name__ == "__main__":
    c1 = _Customer("Li Lei")
    c2 = _Customer("Han Meimei")
    c3 = _Customer("Zhang Shan")

    print("Li Lei spends: ", c1.pay(24.5))
    print("Han Meimei spends: ", c2.pay(28.7))
    print("Li Lei spends: ", c1.pay(7.85))

    print("Li lei spends totally: ", c1.total())
    print("Han Meimei spends totally: ", c2.total())

    new_customer("Li Lei")
    new_customer("Han Meimei")
    new_customer("Zhang Shan")

    print("Li Lei spends: ", pay_price("Li Lei", 12.38))
    print("Li Lei spends: ", pay_price("Li Lei", 18.35))
    print("Li Lei spends: ", pay_price("Li Lei", 31.05))
    print("Li Lei spends totally:", check_total("Li Lei"))
    
    
    
