# 基本协程技术和方法

import time
import asyncio

async def task_co(n):
    print("task{} starts...".format(n))
    await asyncio.sleep(3)
    print("task{} ends.".format(n))
    return "task" + str(n)

def main():
    start = time.time()
    print("tasks starts...")
    loop = asyncio.get_event_loop()
    task = asyncio.gather(*[task_co(i) for i in range(5000)])
    x = loop.run_until_complete(task)
    loop.close()
    print("tasks ends.")
    print("Run time:", time.time() - start)
#    print(x)
    return x

main()

# 50 tasks:   Run time: 3.0401740074157715
# 500 tasks:  Run time: 3.2521860599517822
# 5000 tasks: Run time: 5.609320640563965
