## 下载网页的异步客户端程序

import asyncio
import aiohttp

URLS = (
    'http://www.baidu.com/',
    'http://news.sina.com.cn/',
    'http://www.xinhua.org/',
)

pages = []

async def fetch(session, url):
    global pages
    print("Connecting {}...".format(url))
    async with session.get(url) as site:
        text = await site.text()
    pages.append(text)
    print("Read {} bytes from {}.".format(len(text), url))


async def fetch_all():
    async with aiohttp.ClientSession() as session:
        await asyncio.gather(*[fetch(session, url) for url in URLS])
    print("Done.")


loop = asyncio.get_event_loop()
resp = loop.run_until_complete(fetch_all())
loop.close()





