# 基本协程, future 和 loop.run_forever()
# run_forever() 是同步命令，其执行只能被异步协程终止
# run_forever() 执行其活动过程中存在的所有 future，包括执行期间创建的新 future

import asyncio

async def task_co(n):
    print("task{} starts...".format(n))
    await asyncio.sleep(1)
    print("task{} ends.".format(n))

async def main(loop):
    print("task main starts...")
    await asyncio.ensure_future(task_co(2)) # 动态加入的期程
    await asyncio.sleep(2)
    print("task main ends.")
    loop.stop()

loop = asyncio.get_event_loop()

asyncio.ensure_future(task_co(0))
asyncio.ensure_future(task_co(1))
asyncio.ensure_future(main(loop))

loop.run_forever() # 启动事件循环，运行到 loop.stop() 结束

loop.close()


