# 文件vip_customers.py
# 本模块导入 customers，派生出一个包含VIP客户类和一个扩充的客户管理类
# 在客户对象中记录了客户消费的历史积累值

from customers import *

class VIP(Customer):
    _discount = 0.98
    
    def __init__(self, name, total):
        Customer.__init__(self, name)
        self._total = total

    def pay(self, price):
        paid = round(price * VIP._discount, 2)
        self._total += price
        return paid


class VIPCusManager(CustomerManager):
    _VIP_point = 1000.0

    @classmethod
    def is_VIP(cls, name):
        if (name not in cls._customers or
            not isinstance(cls._customers[name], VIP)):
            return False
        return True

    @classmethod
    def pay_price(cls, name, price):
        if (not isinstance(name, str) or
            not isinstance(price, float)):
            raise TypeError("Purshese Error: ", name, price)
        if name not in cls._customers: # 无此客户时自动添加
            cls._customers[name] = Customer(name)
        customer = cls._customers[name]
        paid = customer.pay(price)
        total = customer.total()
        if (not isinstance(customer, VIP) and
            total > cls._VIP_point):
            cls._customers[name] = VIP(name, total)

        return paid


if __name__ == "__main__":
    cm = VIPCusManager
    cm.new_customer("Li Lei")
    cm.new_customer("Han Meimei")
    cm.new_customer("Zhang Shan")

    print("Li Lei spends: ", cm.pay_price("Li Lei", 253.38))
    print("Li Lei spends: ", cm.pay_price("Li Lei", 806.35))
    print("Li Lei is VIP: ", cm.is_VIP("Li Lei"))
    print("Li Lei spends: ", cm.pay_price("Li Lei", 100.00))
    print("Li Lei spends totally:", cm.check_total("Li Lei"))
    
    
    
