# 文件shapes_2.py
# 本模块定义几个几何形状类
# 主要展示已经定义的类，可以用于定义新的类
# 修改原定义，首先定义一个公共基类 Shape
# 其他形状类都定义为它的派生类
# 与前面不同，这里利用标准库 abc.py 包里的 ABC 类继承

from abc import *

class Shape(ABC):
    @abstractmethod
    def area(self): pass

    @abstractmethod
    def move(self, delta_x, delta_y): pass

    def name(self): return "Shape"

    def show(self):
        print("I am a", self.name() +".",
              "My area is", self.area())

class Uncompleted(Shape):
    def __init__(self): self.a = 1
    def area(self): return 1
    
class Point(Shape):
    def __init__(self, x, y):
        self._x = x
        self._y = y

    def getx(self):
        return self._x

    def gety(self):
        return self._y

    def area(self):
        return 0

    def move(self, delta_x, delta_y):
        self._x += delta_x
        self._y += delta_y

    def name(self): return "Point"

class Rectangle(Shape):
    def __init__(self, point, length, width):
        self._point = point
        self._length = length
        self._width = width

    def getx(self):
        return self._point.getx()
    
    def gety(self):
        return self._point.gety()

    def area(self):
        return self._length * self._width

    def move(self, delta_x, delta_y):
        self._point.move(delta_x, delta_y)

    def name(self): return "Rectangle"


def area(slist):
    s = 0
    for x in slist:
        if isinstance(x, Shape):
            s += x.area()
    return s

if __name__ == "__main__":
    x = Point(2, 3)
    y = Rectangle(x, 3, 5)
    z = Rectangle(x, 6, 8)

    x.show()
    y.show()

    print("Total Area:", area([x, y, z]))   

