# 文件rational_plus.py
# 利用__new__()修改有理数类的两个方法定义

    @classmethod
    def create(cls, num, den, sign=1):
        # 假定num和den是整数，den为正，创建化简的有理数
        r = Rational.__new__(Rational) # 创建新的有理数对象
        g = Rational._gcd(num, den) 
        r._num = sign * (num//g)
        r._den = den//g
        return r

    def __add__(self, another):      # 模拟 + 运算符
        den = self._den * another.den()
        num = (self._num * another.den() +
               self._den * another.num())
        return Rational.create(abs(num), den, 1 if num >= 0 else -1)
