## 文件 linked_list1.py，带尾结点引用的单链表类

from list_node import SLNode
from linked_list import LinkedList, LinkedListUnderflow


class LinkedList1(LinkedList):
    @staticmethod
    def _set_rear(lst):  # 设置尾指针
        p = lst._head
        if p is None: return
        while p.next:
            p = p.next
        lst._rear = p

    def __init__(self, inits=()):
        LinkedList.__init__(self, inits)
        self._set_rear(self)

    def __getitem__(self, key):
        res = LinkedList.__getitem__(self, key)
        if isinstance(key, int):
            return res
        self._set_rear(res)
        return res

    def prepend(self, elem):
        if self._head is None:
            self._head = type(self).Node(elem, self._head)
            self._rear = self._head
        else:
            self._head = type(self).Node(elem, self._head)

    ## prepop(self) 不需要覆盖

    def append(self, elem):
        if self._head:  # empty list
            self._rear.next = type(self).Node(elem)
            self._rear = self._rear.next
        else:
            self._head = self._rear = type(self).Node(elem)
            
    def pop(self):
        if self._head is None:  # 空表
            raise LinkedListUnderflow("pop_last empty LinkedList1")
        p = self._head
        if p.next is None:  # 表只有一个元素
            e = p.elem
            self._head = None
            self._rear = None
            return e
        while p.next.next:  # 循环到p.next是最后结点
            p = p.next
        e = p.next.elem
        p.next = None
        self._rear = p
        return e

    def reverse(self):
        p = self._head # 记录首结点
        LinkedList.reverse(self)
        self._rear = p # 设置为新的尾结点记录

    def sort(self):
        LinkedList.sort(self)
        self._set_rear(self)

    # __reversed__ 不需要覆盖，正好合适


if __name__ == '__main__':
    mlist = LinkedList1()
    mlist.prepend(99)
        
    for i in range(11, 20):
        mlist.append(i)

    print(mlist)

    for x in filter(lambda y: y % 2 == 1, mlist):
        print(x, end=" ")
    print()

    ss = 0
    while mlist:
        ss += mlist.pop()
    print(ss)

    for i in range(10):
        mlist.prepend(i)

    print(mlist)

    mlist = LinkedList1() # 创建空表
    print(mlist)    
    try:
        mlist.pop()
    except LinkedListUnderflow as ex:
        print(type(ex), ex.args, "\n")

    try:
        mlist = LinkedList1(2) # 错误调用，返回空表
    except TypeError as ex:
        print(type(ex), ex.args, "\n")

    mlist = LinkedList1("") # 用空序列初始化
    print(mlist)
    mlist = LinkedList1("abcd") # 用一般序列初始化
    print(mlist)

    mlist = LinkedList1(range(0)) # 用空迭代器初始化
    print(mlist)
    mlist = LinkedList1(range(8)) # 用一般迭代器初始化
    print(mlist)

    if mlist: # 链表可以作为条件真值
        print("The list is not empty.")
    else:
        print("The list is empty.")
        
    for i in range(11, 17):
        mlist.prepend(i)
    for i in range(17, 22):
        mlist.append(i)
    print(mlist, "\n")


    print("链表作为可迭代对象用于描述式")
    print([x for x in mlist if x % 2 == 1]) # 链表可以作为可迭代对象
        

    print("mlist[3] is ", mlist[3]) # 能正确处理整数下标
    try:
        print("Try mlist[-5]")
        x = mlist[-5]
    except IndexError as ex:
        print(ex)
    try:
        print("Try mlist[30]")
        x = mlist[30]
    except IndexError as ex:
        print(ex)

    # 处理各种切片形式
    print(mlist[::])
    print(mlist[3::])
    print(mlist[3:30:])
    print(mlist[3::3])
    print(mlist[::3])
    print(mlist[3:16:3])

    # 用于检查 in 和 not in
    if -1 in mlist:
        print("something wrong.")
    elif 4 in mlist:
        print("4 is in mlist.")

    print("\nSome elements are popped.")
    for i in range(4):
        print(mlist.prepop())
        print(mlist.pop())

    print("\nRemained list:", mlist)

    mlist.reverse()
    print("\nReversed list:", mlist)

    mlist.sort()
    print("\nSorted list:", mlist)

    mlist.mutate_elements(lambda x: x * 2)
    print("\nEvery element doubled:", mlist)


