## 文件doublelinked_list.py，带尾结点引用的双链表类

from list_node import SLNode
from linked_list import LinkedList, LinkedListUnderflow


class DLNode(SLNode):  # 双链表的结点类
    __slots__ = ("prev",) # 实例增加一个域
    def __init__(self, elem, prev=None, next_=None):
        SLNode.__init__(self, elem, next_)
        self.prev = prev


class DLinkedList(LinkedList):  # 双向链接表类
    Node = DLNode

    @staticmethod
    def _set_prev_and_rear(lst):  # 设置反向链和尾指针
        p = lst._head
        if p is None:
            return
        
        p.prev = None
        while p.next:
            p.next.prev = p
            p = p.next
        lst._rear = p

    def __init__(self, inits=()):
        LinkedList.__init__(self, inits)
        self._set_prev_and_rear(self)

    def __getitem__(self, key):
        res = LinkedList.__getitem__(self, key)
        if isinstance(key, int):
            return res
        self._set_prev_and_rear(res)
        return res

    def prepend(self, elem):
        p = DLNode(elem, None, self._head)
        if self._head is None:
            self._rear = p
        else:  # 设置prev引用
            p.next.prev = p
        self._head = p

    def prepop(self):
        if self._head is None:
            raise LinkedListUnderflow("in pop of LDList")
        e = self._head.elem
        self._head = self._head.next
        if self._head:
            self._head.prev = None
        return e

    def append(self, elem):
        p = DLNode(elem, self._rear, None)
        if self._head is None:  # 空表插入第一个结点
            self._head = p
        else:  # 设置下一结点引用
            p.prev.next = p
        self._rear = p

    def pop(self):
        if self._head is None:
            raise LinkedListUnderflow("in pop_last of LDList")
        e = self._rear.elem
        self._rear = self._rear.prev
        if self._rear is None:  # 弹出后变空表
            self._head = None
        else:
            self._rear.next = None
        return e

    def reverse(self):
        LinkedList.reverse(self)
        self._set_prev_and_rear(self)

    def sort(self):
        LinkedList.sort(self)  # 调用LinkedList的排序方法
        self._set_prev_and_rear(self)

    def __reversed__(self):  # 供标准函数reversed调用
        p = self._rear
        while p:
            yield p.elem
            p = p.prev


if __name__ == '__main__':
    from random import randint
    mlist = DLinkedList()
    for i in range(10):
        mlist.prepend(randint(i, 30))
    for i in range(11, 20):
        mlist.append(randint(1, 50))

    print(mlist)

    for x in filter(lambda y: y % 2 == 1, mlist):
        print(x, end=" ")
    print()

    for i in range(5):
        if mlist:
            print(mlist.prepop())
        if mlist:
            print(mlist.pop())

    print(mlist)

    for i in range(3):
        mlist.prepend(randint(i + 10, 50))
        mlist.append(randint(i + 50, 60))
    print(mlist)

    print(list(reversed(mlist))) # 检查反向链

    seg = mlist[2::3] # 测试切片和反向链的正确设置
    print(seg)
    print(list(reversed(seg)))

    mlist.reverse()   # 检查反转操作，操作后反向链正常
    print(mlist)
    print(list(reversed(mlist)))

    mlist.sort()      # 检查排序操作，操作后反向链正常
    print(mlist)
    print(list(reversed(mlist)))

    
