# 文件conntext_manager.py
# 定义里一个简单的上下文管理器，展示这种结构的定义方式和功能

from random import random

class Context:
    def __enter__(self):
        print("__enter__() executed")
        return self
 
    def __exit__(self, type, value, trace):
        print("__exit__() executed", type, value, trace)

    def action(self):
        print("action() executed")
        rm = random()
        if rm < 0.5:
            return "action ends"
        else:
            raise RuntimeError(rm)
 
 
def test_with(n):
    for i in range(n):
        try:
            with Context() as con:
                print("Context:", con.action())
        except RuntimeError as ex:
            print(type(ex), ex.args[0])

if __name__ == "__main__":
    test_with(4)
