### 采用闭包技术定义银行账户对象

def account(user, init=0):
    def deposit(v):
        nonlocal amount, history
        history.append(("deposit", v))
        amount += v
        print(user_name, "depositing", v, "done")
        
    def withdrew(v):
        nonlocal amount, history
        if v > amount:
            print("No enough money in account.")
            return
        history.append(("withdrew", v))
        amount -= v
        print(user_name, "withdrewing", v, "done")

    def dispatcher(command, v=0):
        if command == "id":
            return idnum
        elif command == "name":
            return user_name
        elif command == "amount":
            return amount
        elif command == "history":
            return tuple(history)
        elif command == "deposit":
            deposit(v)
        elif command == "withdrew":
            withdrew(v)
        else:
            return "Not understood."

    if (not isinstance(user, str) or
        not isinstance(init, int) or init < 0):
        print("name should be str",
              "and init should be non-negative integer.")
        print("Please try again.")
        return None
    amount = init
    user_name = user
    history = [init]
    print("Account for", user,
          "created, with initially", str(amount)+".")

    return dispatcher
    

if __name__ == "__main__":     
    act1 = account("Liu", 3000)
    act2 = account("Lei")

    act1("deposit", 340)
    act1("withdrew", 90)
    act2("deposit", 400)
    act2("deposit", 280)

    print("Account for", act1("name")+":", act1("amount"))
    print("Account for", act2("name")+":", act2("amount"))
    print(act1("name")+" history:", act1("history"))

