####  一个简单的电话薄程序
## 电话薄的内存表示：联系人名 -> 联系人记录 的字典
##       联系人记录：域名 -> 域值 的字典
##
## 文件表示：一个联系人记录表示为一些行
##       第一行 name .....
##       其余的行均以域名开头，后跟该域的值（字符串）


def load_phonebook(infile): # 这里假定了文件格式正确
    book = {}

    for line in infile:
        if line == "\n": # 跳过空行
            continue
        if line[:4] == "name": # 遇到新联系人
            name = line[5:].strip()
            book[name] = {} # 为联系人创建字典项，值是空字典
        else:
            entry = line.split(maxsplit=1)
            book[name][entry[0]] = entry[1].strip()

    return book

def save_phonebook(book, outfile):
    for name, record in book.items():
        outfile.write("name " + name + "\n")
        for field, value in record.items():
            outfile.write(field + " " + value + "\n")
        outfile.write("\n")


phonebook = {}

def phone():
    name = input("Name: ")
    if name in phonebook:
        print(phonebook[name]["phone"])
    else:
        print("No such name in the phonebook.")


def add():
    name = input("Name: ")
    if name not in phonebook:
        phonebook[name] = {}
        number = input("Phone number: ")
        phonebook[name]["phone"] = number
        yesno = input("Other entry (yes/no)? ")
        if yesno.lower() != "yes":
            return
    print("Entry form: entry-name entry-value")
    while True:
        line = input("Next entry (direct return to break): ")
        if line == "": # direct return then
            return
        entry = line.split(maxsplit=1)
        phonebook[name][entry[0]] = entry[1].strip()


def load():
    global phonebook

    infile = open(input("File name: ") + ".bok")
    phonebook = load_phonebook(infile)
    infile.close()


def save():
    if phonebook == None:
        print("Phonebook has not loaded.")
        return

    outfile = open(input("File name: ") + ".bok", "w")
    save_phonebook(phonebook, outfile)
    outfile.close()


# 命令字典，元组的第二项是命令说明串，用于提示用户
commands = {
    "load": (load, "load a phonebook file"),
    "save": (save, "save the phonebook into a file"),
    "phone": (phone, "search the telephone number for a name"),
    "add": (add, "add a contact and/or entries")
    }

# 开始时给用户输出一些使用信息
print("""This is a phonebook program. Please type command,
or type "quit" to quit the program.\n""")
for cmd, value in commands.items():
    print(cmd + ":", value[1])
print("\nPlease load a phonebook before uses.")

# 主操作循环
while True:
    cmd = input("Command>> ")
    if cmd == "quit":
        if not phonebook:
            break
        yesno = input("Save the phonebook (yes/no)? ")
        if yesno.lower() != "no":
            save()
        break

    if cmd in commands:
        commands[cmd][0]()
    else:
        print("No such command! Continue.")

##if __name__ == "__main__":
##    book = {"Zhang San":
##            {"phone": "13302352829", "email": "zs@pku.edu.cn"},
##            "Li Si":
##            {"phone": "13523371058", "email": "zs@nju.edu.cn"}
##           }
##
##    ofile = open("phonebk1.bok", "w")
##    save_phonebook(book, ofile)
##    ofile.close()
##
##    ifile = open("phonebk1.bok")
##    book1 = load_phonebook(ifile)
##    print(book)
##    print(book1)



    
