# 实现牛顿迭代法的函数
# 这里利用lambda表达式定义了一个实现数值微分的函数diff
# 它可以从任意Python函数生成其导函数的数值微分近似函数
# 满足牛顿迭代法的需要

def newton(f, init):
    def diff(f):
        return lambda x: (f(x + epsilon) - f(x))/epsilon

    def improve(x1):
        return x1 - f(x1)/df(x1)
    
    epsilon = 0.001
    df = diff(f)
    x1 = init
    while abs(f(x1)) > 1e-6:
        x1 = improve(x1)
    return x1

from math import sin, cos
print("newton(sin, 1.0)")
print("We have:", newton(sin, 1.0))
print("newton(cos, 1.9)")
print("We have:", newton(cos, 1.9))





