# 计算立方根的程序

def cbrt(x):
    def not_enough(x, guess, old):
        return abs((guess - old) / x) > 1e-6

    def improve(x, guess):
        return (2.0 * guess + x / guess / guess) / 3

    if x == 0.0:
        return 0.0

    guess, old = x, 0.0
    while not_enough(x, guess, old):
        old = guess
        guess = improve(x, guess)
    return guess

for x in 0.000001, 0.001, 1, 1000, 1e6:
    print("Cube root of", x, "is", cbrt(x))




