# 计算立方根的程序

def not_enough(x, guess, old):
    return abs((guess - old) / x) > 1e-6

def improve(x, guess):
    return (2.0 * guess + x / guess / guess) / 3

def sqrt_improve(x, guess):
    return (guess + x / guess) / 2

def appr_method(x, not_enough, improve):
    if x == 0.0:
        return 0.0

    guess, old = x, 0.0
    while not_enough(x, guess, old):
        old = guess
        guess = improve(x, guess)
    return guess

def cbrt(x):
    return appr_method(x, not_enough, improve)

def sqrt(x):
    return appr_method(x, not_enough, sqrt_improve)

print("Cube root for 2, 4, 8, 16, 32, 64:")
for x in 2, 4, 8, 16, 32, 64:
    print("Cube root of", x, "is", cbrt(x))

print("Square root for 2, 4, 8, 16, 32, 64:")
for x in 2, 4, 8, 16, 32, 64:
    print("Cube root of", x, "is", sqrt(x))





