# 文件vip_customer_manager.py
# 导入 customers_manager，从 _Customer 类派生定义一个 VIP 客户类
# 实现扩充的客户管理功能

import customer_manager as _cm

class _VIP(_cm._Customer):
    _discount = 0.98
    
    def __init__(self, name, total):
        _cm._Customer.__init__(self, name)
        self._total = total

    def pay(self, price):
        paid = round(price * _VIP._discount, 2)
        self._total += paid
        return paid

_VIP_point = 1000.0

def is_VIP(name):
    if (name not in _cm._customers or
        not isinstance(_cm._customers[name], _VIP)):
        return False
    return True

def pay_price(name, price):
    if (not isinstance(name, str) or
        not isinstance(price, float)):
        raise TypeError("Purshese Error: ", name, price)
    if name not in _cm._customers: # 无此客户时自动添加
        _cm._customers[name] = _cm._Customer(name)
    customer = _cm._customers[name]
    paid = customer.pay(price)
    total = customer.total()
    if (not isinstance(customer, _VIP) and
        total > _VIP_point):
        _cm._customers[name] = _VIP(name, total)

    return paid

def new_customer(name): _cm.new_customer(name)
def check_total(name): return _cm.check_total(name)

if __name__ == "__main__":
    new_customer("Li Lei")
    new_customer("Han Meimei")
    new_customer("Zhang Shan")

    print("Li Lei spends: ", pay_price("Li Lei", 253.38))
    print("Li Lei spends: ", pay_price("Li Lei", 806.35))
    print("Li Lei is VIP: ", is_VIP("Li Lei"))
    print("Li Lei spends: ", pay_price("Li Lei", 100.00))
    print("Li Lei spends totally:", check_total("Li Lei"))
    
    
    
