#### 类装饰器，用于创建单例类

## 功能正确的单例装饰器，通过修改类定义中的__new__方法完成
## instance记录在闭包里，可以避免与被装饰类的属性冲突
## 虽然原类的__init__被正常调用，但总是操作第一次创建的实例
def singleton(cls):
    instance = None

    def create(*args, **kwargs):
        nonlocal instance
        if instance is None:
            instance = object.__new__(cls)
        return instance

    cls.__new__ = create

    return cls


## 另一个实现单例类的装饰器函数
## 缺点是用于装饰一个类，结果是一个生成单例的工厂函数
## 被装饰的原类丢失，无法支持复杂的需求
def singleton1(cls):
    instance = None

    def wapper(*args, **kwargs): 
        nonlocal instance 
        if instance == None:
            instance = cls(*args, **kwargs)
        return instance
    
    return wapper


## 一个实现单例类的装饰器类
## 缺点是用于装饰一个类，结果另一个类的对象
## 被装饰的原类丢失，无法支持复杂的需求
class singleton2:
    def __init__(self, cls):
        self.cls = cls
        self.instance = None
        
    def __call__(self, *args, **kwargs):
        if self.instance == None:
            self.instance = self.cls(*args, **kwargs)
        return self.instance


@singleton
class Test:
    num = 0

    def __init__(self, n):
        self.value = n
        Test.num += 1

    def getnum(self):
        return Test.num


if __name__ == "__main__":
    for i in range(4):
        x = Test(i)

    print(Test.num)

    y = Test(10)
    print("Singleton" if x is y else "Not-Singleton")


