#### 结合计时修饰器函数和元类技术
## 定义一个元类，为它的类中每个函数增加计时功能

import time
from types import FunctionType

def timing(fun):
    accum = 0.0
    def timer(*args, **kwargs):
        nonlocal accum
        print(fun.__name__ + " starts.")
        start = time.clock()
        x = fun(*args, **kwargs)
        duration = time.clock() - start
        accum += duration
        print("{} ends: {:12.6f}, {:12.6f}".format(fun.__name__,
                                                   duration, accum))
        return x

    return timer

class MetaTiming(type):
    def __new__(cls, clsname, bases, attrdict, **kwds):
        if __debug__:
            for attr, val in attrdict.items():
                if callable(val):       # attr是方法
                    attrdict[attr] = timing(val)    # 装饰这个方法
        return type.__new__(cls, clsname, bases, attrdict)

class C(metaclass=MetaTiming):
    def f1(self, a, b):
        sum = 0
        for i in range(a, b): sum += i
        return sum

    def f2(cls, n):
        s = 1
        for i in range(n): s *= i
        return s


if __name__ == "__main__":
    x = C()
    print(x.f1(100000, 200000))
    print(x.f2(100000))


