# 展示元类技术的示例，取自Python语言手册3.3.3.5节
# 这里定义一个简单元类，基于它定义的类记录了属性创建的顺序

import collections
        
class OrderedClass(type):

     @classmethod
     def __prepare__(metacls, name, bases, **kwds):
        return collections.OrderedDict()

     def __new__(cls, name, bases, namespace, **kwds):
        result = type.__new__(cls, name, bases, dict(namespace))
        result.members = tuple(namespace)
        
        return result
        

if __name__ == "__main__":
    class A(metaclass=OrderedClass):
        zero = 0
        def one(self): pass
        def two(self): pass
        three = 3
        def four(self): pass

    print(A.members)

