#### 生成器函数，yield表达式

def gen1():
    for i in range(10):
        cmd = (yield i)
        if cmd == "stop":
            return
        print(cmd)

def accumulator(acc=0):
    print("Started, and send() to go on.")
    try:
        while True:
            cmd = (yield acc)
            if isinstance(cmd, int):
                acc += cmd
            elif cmd == "reset":
                acc = 0
            else:
                break
    except: pass

    print("Please clean up this gen object.")
    return acc

## Example from Language Manual
def echo(value=None):
    print("Execution starts when 'next()' is called for the first time.")
    try:
        while True:
            try:
                value = (yield value)
            except Exception as e:
                value = e
    finally:
        print("Don't forget to clean up when 'close()' is called.")

if __name__ == "__main__":
    pass

