## 体现 __setattr__ 和 __getattr__ 功能的代码

print("Test __describtor__.")

class Descriptor:
    def __get__(self, instance, owner):
        print(self, instance, owner, sep='\n')
    def __set__(self, instance, value):
        print(self, instance, value, sep='\n')
        raise AttributeError('Set is forbidden.')

class Client:
    attr = Descriptor() # Descriptor instance is class attr
    
x = Client()
x.attr
Client.attr
