#### 修饰器函数

def func1(a, b):
    print(a + b)
    return a + b

def func2(a, b, c):
    print(a + b * c)
    return a + b * c

def deco_func(a, b):
    print("func starts.")
    x = func1(a, b)
    print("func ends.")
    return x

def deco1(fun, *args, **kwargs):
    print(fun.__name__ + " starts.")
    x = fun(*args, **kwargs)
    print(fun.__name__ + " ends.")
    return x

def deco(fun):
    def wrapper(*args, **kwargs):
        print(fun.__name__ + " starts.")
        x = fun(*args, **kwargs)
        print(fun.__name__ + " ends.")
        return x

    return wrapper

@deco
def func3(a, b, c, d):
    print(a + b * c - d)
    return a + b * c - d

def decodeco(fun):
    def wrapper(*args, **kwargs):
        print(fun.__name__ + " ......")
        x = fun(*args, **kwargs)
        print(fun.__name__ + " ------")
        return x

    return wrapper

@decodeco
@deco
def func4(a, b, c, d, e):
    print(a, b, c, d, e)
    print(a + b * c - d + e)
    return a + b * c - d + e

class C:
    def __init__(self, v):
        self.v = v

    @deco
    def add(self, n):
        self.v += n

    @deco
    def value(self):
        return self.v


if __name__ == "__main__":
    deco_func(1, 4)
    
    print("\n-----------------")
    deco1(func1, 1, 4)
    deco1(func2, 2, 3, 4)

    print("\n-----------------")

    func1 = deco(func1)
    func2 = deco(func2)
    func1(1, 4)
    func2(2, 3, 4)
    
    print("\n-----------------")
    func3(2, 3, 4, 2)
    func3(2, 3, 4, 2)

    print("\n-----------------")
    func4(2, 3, 4, 2, 10)
    print()
    func4(8, 3, 5, 7, 2)


