# 基本协程技术和方法

import time

def task1():
    print("task1 starts...")
    time.sleep(1)
    print("task1 ends.")
    return "task1"

def task2():
    print("task2 starts...")
    time.sleep(3)
    print("task2 ends.")
    return "task2"

def task3():
    print("task3 starts...")
    time.sleep(2)
    print("task3 ends.")
    return "task3"

def main():
    start = time.time()
    print("tasks starts...")
    x = [task1(), task2(), task3()]
    print("tasks ends.")
    print("Run time:", time.time() - start)
    print(x)
    return x

main()

print("\n++++++++++++++++++++\n")

import asyncio

async def task1co():
    print("task1 starts...")
    await asyncio.sleep(1)
    print("task1 ends.")
    return "task1"

async def task2co():
    print("task2 starts...")
    await asyncio.sleep(3)
    print("task2 ends.")
    return "task2"

async def task3co():
    print("task3 starts...")
    await asyncio.sleep(2)
    print("task3 ends.")
    return "task3"

def main():
    start = time.time()
    print("tasks starts...")
    loop = asyncio.get_event_loop()
    task = asyncio.gather(task1co(), task2co(), task3co())
    x = loop.run_until_complete(task)
    loop.close()
    print("tasks ends.")
    print("Run time:", time.time() - start)
    print(x)
    return x

main()


loop = asyncio.get_event_loop()
# task = asyncio.gather(...)
try:
    x = loop.run_until_complete(task)
finally:
    loop.close()
