## 异步文件数据处理程序

import asyncio
import aiofiles
import sys

inqueue = asyncio.Queue()
outqueue = asyncio.Queue()

async def reader(fname, inq):
    async with aiofiles.open(fname) as infile:
        async for line in infile:
            await inq.put(line)
            
        await inq.put("end")
    print("Reader finished.")


def prime_factors(n):
    def nextpf(n): # 给出下一个素因子
        d = 2
        while d * d <= n:
            if n % d == 0:
                return d
            d += 1
        return n

    flist = []
    while n != 1: # 反复求素因子并从 n 中除掉它
        p = nextpf(n)
        flist.append(p) # 在表中积累素因子
        n //= p

    return flist

async def worker(inq, outq):
    while True:
        line = await inq.get()
        if line == "end":
            break
        for numstr in line.split():
            num = int(numstr)
            factors = prime_factors(num)
            await outq.put("{}: {}\n".format(num, str(factors)))

    await outq.put("end")
    print("Worker finished.")


async def writer(fname, outq):
    async with aiofiles.open(fname, "w") as outfile:
        while True:
            line = await outq.get()
            if line == "end":
                break
            await outfile.write(line)

    print("Writer finished.")


tasks = asyncio.gather(
    reader(sys.argv[1], inqueue),
    worker(inqueue, outqueue),
    writer(sys.argv[2], outqueue)
    )

loop = asyncio.get_event_loop()
resp = loop.run_until_complete(tasks)
loop.close()
print("Done!")





