#### 函数装饰器，用于定义带检查功能的函数
#### 被装饰函数用annotaions描述对检查的要求

def checkarguments(fun):
    annotations = fun.__annotations__
    code = fun.__code__
    argnames = code.co_varnames[:code.co_argcount]
    print(argnames)

    def deco(*args):
        for i in range(code.co_argcount):
            value = args[i]
            anno = annotations[argnames[i]]
            if value < anno[0] or value > anno[1]:
                raise ValueError("Argument {} for fun {} is out of range.".
                                 format(i, fun.__name__))
        return fun(*args)

    return deco

@checkarguments
def daysecond(hour:(0,23), minute:(0,59), second:(0,59)):
    return (hour * 60 + minute) * 60 + second


if __name__ == "__main__":
    print(daysecond(20, 28, 57))
    print(daysecond(-2, 72, 34))
    print(daysecond(28, -4, 22))
    print(daysecond(20, 28, 99))
    print(daysecond(20, 67, 57))


